
*************************** SETUP *************************** 


insheet using "mp_dates.csv", clear name
g year = substr(date,1,4)
g month = substr(date,6,2)
g day = substr(date,9,2)
destring year month day, replace
gen d=mdy(month,day,year)
format %td d

g board = 1
keep d board
save "board_meetings.dta", replace

*mp_shocks series not publicly available
insheet using "mp_shocks.csv", clear name
g year = substr(decision_date,1,4)
g month = substr(decision_date,6,2)
g day = substr(decision_date,9,2)

keep year month day ois_1m 
destring _all , replace  ignore("NA")
save "ois_shocks.dta", replace


import excel using "rr_shocks.xlsx", clear first

g month = month(Date)
g year = year(Date)

rename Bishop bishop
*rename BTNSI btnsi 
rename BTCS btcs 
*rename BTCNSI btcnsi 
rename Cash cratechange 
keep bishop bt* month year crate 

save "mpshocks.dta", replace


insheet using "f1-data.csv", clear
keep v1 v2 v13 v14 v15
rename v1 date
rename v2 crate
rename v13 ois1
rename v14 ois3
rename v15 ois6

drop in 1/11
destring crate, replace

g year = substr(date,8,4)
destring year, replace
g month1 = substr(date,4,3)
g day = substr(date,1,2)
destring day, replace

replace month1 = lower(month1)
g month = .
replace month = 1 if month1 == "jan"
replace month = 2 if month1 == "feb"
replace month = 3 if month1 == "mar"
replace month = 4 if month1 == "apr"
replace month = 5 if month1 == "may"
replace month = 6 if month1 == "jun"
replace month = 7 if month1 == "jul"
replace month = 8 if month1 == "aug"
replace month = 9 if month1 == "sep"
replace month = 10 if month1 == "oct"
replace month = 11 if month1 == "nov"
replace month = 12 if month1 == "dec"

gen d=mdy(month,day,year)
format %td d
keep crate d ois* 
destring crate ois*, replace
save "crate_2011_2020.dta", replace

import excel using "f01dhist.xls", clear sheet(Data)
keep A B H I J 
rename A date
rename B crate
rename H ois1 
rename I ois3
rename J ois6

drop in 1/11
destring crate ois* , replace

g year = substr(date,6,4)
destring year, replace
g month1 = substr(date,3,3)
g day = substr(date,1,2)
destring day, replace

g month = .
replace month = 1 if month1 == "jan"
replace month = 2 if month1 == "feb"
replace month = 3 if month1 == "mar"
replace month = 4 if month1 == "apr"
replace month = 5 if month1 == "may"
replace month = 6 if month1 == "jun"
replace month = 7 if month1 == "jul"
replace month = 8 if month1 == "aug"
replace month = 9 if month1 == "sep"
replace month = 10 if month1 == "oct"
replace month = 11 if month1 == "nov"
replace month = 12 if month1 == "dec"

gen d=mdy(month,day,year)
format %td d
drop if year < 1980
drop if year > 2010
keep crate d ois* 
destring crate, replace force
save "crate_1980_2010.dta", replace

append using "crate_2011_2020.dta"
save "crate_1980_2020.dta", replace


insheet using "ASX_all_ord.csv", clear 
drop in 1/2 
rename v1 date
rename v2 asx 
g length = length(date)

g year = substr(date,7,4)
replace year = substr(date,6,4) if length == 9

g month = substr(date,4,2)
replace month = substr(date,3,2) if length == 9

g day = substr(date,1,2)
replace day = substr(date,1,1) if length == 9

destring year month day, replace
keep year month day asx 
destring asx, replace
save "asx_2001_2020.dta", replace

*bloomberg_economic_news series not publicly available
insheet using "bloomberg_economic_news.csv", clear 
keep date event 
g type = substr(event,1,3)
g year = substr(date,1,4)
g month = substr(date,6,2)
g day = substr(date,9,2)

g cpi = (type == "CPI")
g lfs = (type == "Une")
g gdp = (type == "GDP")
destring year month day, replace
keep year month day cpi lfs gdp 
save "releases.dta", replace

